 ; Ŀ
 ;   Txtt - Text To Title (without path).                                  
 ;   Copyright 1990, 2002, 2004, 2006 - 2008 by Rocket Software Ltd.       
 ;   Also contains:                                                        
 ;   - - text To "-".                                                      
 ;   20 - text To "#2/0 Gnd".                                              
 ;   2G - text To "#2 Gnd".                                                
 ;   Asr - text to "A/R".                                                  
 ;   Asb - text to "As-Built Per Field Markups".                           
 ;   Barr - text to "Barrier".                                             
 ;   Cod - text to "Continued on Dwg."                                     
 ;   Coda - text to "Continued on Dwg. Current_dwgname."                   
 ;   Ea - empty an attribute.                                              
 ;   Future - text to "Future".                                            
 ;   Hold - text to "Hold".                                                
 ;   Ifc - text To "Issued For Construction".                              
 ;   Note - text to "Note 1".                                              
 ;   N1 - text to "Note 1".                                                
 ;   N2 - text to "Note 2".                                                
 ;   N3 - text to "Note 3".                                                
 ;   Nts - text to "Nts".                                                  
 ;   Part - text to "Part Of".                                             
 ;   Txpp - text To Title with path.                                       
 ;   Txd - text To date in short year format.                              
 ;   Txdd - text To date in long year format.                              
 ;   Scal - text to 1 : drawing scale.                                     
 ;   Spare - text to "Spare" or "Spare n", depending.                      
 ;   Computers will free us all from drudgery...in the year 2497.          
 ;   Until then, use Rocket Software.                                      
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
            (setq thestr (strcat thestr sepstr astr)))
            alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Monster - separate a text string into numbers and letters.            
 ;   Copyright 1992 by Rocket Software Ltd.                                
 ;   This function returns a list of strings, alternating between          
 ;   numbers and letters.  The first string is always a character string   
 ;   - if the first character is a number then the first string will be    
 ;   empty ("").                                                           
 ;   A period (.) will be interpreted as being the same type as the        
 ;   preceding character.                                                  
 ; 
 (DEFUN MONSTER (string / chastr pre ascnum posi this asc last strlist)
  (setq chastr "")
  (setq pre "c")
  (setq ascnum (list 48 49 50 51 52 53 54 55 56 57))
  (setq posi 1)
  (while (/= "" (setq this (substr string posi 1)))
       (setq asc (ascii this))
       (cond ((member asc ascnum)         ; if char is a number
              (setq last "n"))
             ((= asc 46)                  ; if char is a .
              (if (= last "c")
                  (setq last "c")
                  (setq last "n")))
             (T                           ; otherwise it must be a letter
               (setq last "c")))
 ; Ŀ
 ;   If pre = last then strcat "this" onto chastr.                         
 ;   If not then append chastr onto strlist and set chastr to this.        
 ; 
       (if (equal pre last)
           (setq chastr (strcat chastr this))
           (progn
                (if strlist
                   (setq strlist (append strlist (list chastr)))
                   (setq strlist (list chastr)))
                (setq chastr this)))
       (setq pre last)
       (setq posi (1+ posi)))
  (if chastr (setq strlist (append strlist (list chastr))))
 strlist)
 ; Ŀ
 ;   Monster end.                                                          
 ; 

 ; Ŀ
 ;   Snortme - Split a text string around the last number it contains.     
 ;   Argument: Txt, a text string.                                         
 ;   Calls Monster and Listi.                                              
 ;   Returns a list: (string number string).                               
 ; 
 (DEFUN SNORTME (txt / txt strlst pos num gnulst pref len suff typ)
 ; Ŀ
 ;   Split the string into letters and numbers.                            
 ; 
  (setq strlst (monster txt))
 ; Ŀ
 ;   Find the last substring which is a number.                            
 ; 
  (setq pos (1- (length strlst)))
  (while (and (>= pos 0)
              (not (member (type (read (nth pos strlst))) '(int real))))
         (setq pos (1- pos)))
 ; Ŀ
 ;   Make the prefix string.                                               
 ; 
  (if (>= pos 0)
      (progn
           (setq num 0)
           (while (<= num (1- pos))
                  (setq gnulst (append gnulst (list (nth num strlst))))
                  (setq num (1+ num)))
           (setq pref (listi gnulst "")))
      (setq pref ""))
 ; Ŀ
 ;   Make the suffix string.                                               
 ; 
  (setq gnulst ())
  (if (<= pos (setq len (1- (length strlst))))
      (progn
           (while (> len pos)
                  (setq gnulst (cons (nth len strlst) gnulst))
                  (setq len (1- len)))
           (setq suff (listi gnulst "")))
      (setq suff ""))
 ; Ŀ
 ;   Extract the number.                                                   
 ; 
  (if (>= pos 0)
      (setq num (read (nth pos strlst))))
      (setq typ (type num))
 (list pref num suff))
 ; Ŀ
 ;   Snortme end.                                                          
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Toaxt - Text To something.                                 
 ;   Arguments: Rasp, a replacement string.                                
 ;              Proma, a prompt, if nil then use the string in Rasp.       
 ;   Calls nothing, returns the ename of the selected text or nil.         
 ;   Breeds budgies.                                                       
 ; 
 (defun TOAXT (rasp proma / snapp nent enam entt typ outer)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (setvar "snapmode" snapp) (princ))
  (if (null proma)
      (setq proma (strcat rasp ": ")))
  (setq enam (car (setq nent (nentsel proma))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (entmod (subst (cons 1 rasp) (assoc 1 entt) entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer))))
  (setvar "snapmode" snapp)
  (command "undo" "end")
 enam)
 ; Ŀ
 ;   Subroutine Toaxt end.                                                 
 ; 

 ; Ŀ
 ;   - - Text To "-".                                                      
 ; 
 (defun C:- ()
  (toaxt "-" nil)
 (princ))

 ; Ŀ
 ;   20 - Text To "#2/0 GND".                                              
 ; 
 (defun C:20 ()
  (toaxt "#2/0 GND" nil)
 (princ))

 ; Ŀ
 ;   40 - Text To "#4/0 GND".                                              
 ; 
 (defun C:40 ()
  (toaxt "#4/0 GND" nil)
 (princ))

 ; Ŀ
 ;   2G - Text To "#2 GND".                                                
 ; 
 (defun C:2G ()
  (toaxt "#2 GND" nil)
 (princ))

 ; Ŀ
 ;   Asr - text to A/R.                                                    
 ; 
 (defun C:ASR ()
  (toaxt "A/R" nil)
 (princ))

 ; Ŀ
 ;   Asb - text to As-Built Per Field Markups.                             
 ; 
 (defun C:ASB ()
  (toaxt "AS-BUILT PER FIELD MARKUPS" nil)
 (princ))

 ; Ŀ
 ;   Barr - text to Barrier.                                               
 ; 
 (defun C:BARR ()
  (toaxt "BARRIER" nil)
 (princ))

 ; Ŀ
 ;   Cod - text to Continued on Dwg.                                       
 ; 
 (defun C:COD ()
  (toaxt "CONTINUED ON DWG." nil)
 (princ))

 ; Ŀ
 ;   Coda - text to Continued on Dwg. Current_dwgname.                     
 ; 
 (defun C:CODA (/ tt)
  (setq tt (strcase (getvar "dwgname")))
  (if (= (substr tt (- (strlen tt) 3)) ".DWG")
      (setq tt (substr tt 1 (- (strlen tt) 4))))
  (toaxt (strcat "CONTINUED ON DWG. " tt) nil)
 (princ))

 ; Ŀ
 ;   Ea - empty an attribute.                                              
 ; 
 (defun C:EA ()
  (toaxt "" "Attribute to Empty: ")
 (princ))

 ; Ŀ
 ;   Future - Text To "Future".                                            
 ; 
 (defun C:FUTURE ()
  (toaxt "FUTURE" nil)
 (princ))

 ; Ŀ
 ;   Hold - Text To "Hold".                                                
 ; 
 (defun C:HOLD ()
  (toaxt "HOLD" nil)
 (princ))

 ; Ŀ
 ;   Ifc - Text To "Issued For Construction".                              
 ; 
 (defun C:IFC ()
  (toaxt "ISSUED FOR CONSTRUCTION" nil)
 (princ))

 ; Ŀ
 ;   Note - Text To "Note 1".                                              
 ; 
 (defun C:NOTE ()
  (toaxt "NOTE 1" nil)
 (princ))

 ; Ŀ
 ;   N1 - Text To "Note 1".                                                
 ; 
 (defun C:N1 ()
  (toaxt "NOTE 1" nil)
 (princ))

 ; Ŀ
 ;   N2 - Text To "Note 2".                                                
 ; 
 (defun C:N2 ()
  (toaxt "NOTE 2" nil)
 (princ))

 ; Ŀ
 ;   N3 - Text To "Note 3".                                                
 ; 
 (defun C:N3 ()
  (toaxt "NOTE 3" nil)
 (princ))

 ; Ŀ
 ;   Nts - Text To "Nts".                                                  
 ; 
 (defun C:NTS ()
  (toaxt "NTS" nil)
 (princ))

 ; Ŀ
 ;   Part - text to "Part Of".                                             
 ; 
 (defun C:PART ()
  (toaxt "PART OF" nil)
 (princ))

 ; Ŀ
 ;   Scal - Text to "1 : (drawing_scale)".                                 
 ; 
 (defun C:SCAL (/ dimscl scl)
  (setq dimscl (getvar "dimscale"))
  (if (= dimscl (fix (getvar "dimscale")))
      (setq scl (itoa (fix dimscl)))
      (setq scl (rtos dimscl 2 2)))
  (setq scl (strcat "1 : " scl))
  (toaxt scl nil)
 (princ))

 ; Ŀ
 ;   Spare - text to "Spare."                                              
 ;   If a line contains the word Spare and a number, use that as the       
 ;   base and increment the number with each successive selection.         
 ;   If it doesn't then change it to Spare.                                
 ; 
 (DEFUN C:SPARE (/ snapp *error* enam nent entt outer txt num pref suff typ
                                                          numstr gnustr stop)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /)
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get a text-like entity.                                               
 ; 
  (setq enam (car (setq nent (nentsel "Spare: "))))
  (setq entt (entget enam))
  (setq outer (car (reverse (car (reverse nent)))))
  (setq txt (cdr (assoc 1 entt)))
 ; Ŀ
 ;   See if the string is or contains the substring Spare.                 
 ; 
 (cond ((= (strcase txt t) "spare")
 ; Ŀ
 ;   If is is, then add a 1.                                               
 ; 
        (entmod (subst (cons 1 (strcat txt " 1")) (assoc 1 entt) entt))
        (entupd enam)
        (if (= (type outer) 'ENAME) (entupd outer)))
 ; Ŀ
 ;   If not then install it.                                               
 ; 
       ((zerop (sonar "spare" txt t))
        (entmod (subst (cons 1 "SPARE") (assoc 1 entt) entt))
        (entupd enam)
        (if (= (type outer) 'ENAME) (entupd outer)))
 ; Ŀ
 ;   If so then ... how much can one assume?                               
 ;   Split the string into letters and numbers, increment the last         
 ;   number set, put it back together and install into text as required.   
 ; 
       (t
        (setq num (snortme txt))
        (setq pref (car num))
        (setq suff (caddr num))
        (setq num (cadr num))
        (setq typ (type num))
 ; Ŀ
 ;   Ask for new text to put it in.                                        
 ; 
        (while (null stop)
               (setq num (1+ num))
               (cond ((= typ 'int) (setq numstr (itoa num)))
                     ((= typ 'real) (setq numstr (rtos num))))
               (setq gnustr (strcat pref numstr suff))
               (setq stop (not (toaxt gnustr nil))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))

 ; Ŀ
 ;   Txpp - Text to title with Path.                                       
 ; 
 (defun C:TXPP ( / tt)
  (setq tt (strcase (getvar "dwgname")))
  (if (= (substr tt (- (strlen tt) 3)) ".DWG")
      (setq tt (substr tt 1 (- (strlen tt) 4))))
  (setq tt (strcat (getvar "dwgprefix") tt))
  (toaxt tt "Text: ")
 (princ))

 ; Ŀ
 ;   Txtt - Text To Title without path.                                    
 ; 
 (defun C:TXTT ( / tt)
  (setq tt (strcase (getvar "dwgname")))
  (if (= (substr tt (- (strlen tt) 3)) ".DWG")
      (setq tt (substr tt 1 (- (strlen tt) 4))))
  (toaxt tt nil)
 (princ))

 ; Ŀ
 ;   Txd - Text to Date in short year format.                              
 ; 
 (defun C:TXD ( / tt dd yy mm)
  (setq dd (rtos (fix (getvar "cdate"))))
  (setq yy (substr dd 3 2) mm (substr dd 5 2) da (substr dd 7 2))
  (setq dd (strcat yy "." mm "." da))
  (toaxt dd nil)
 (princ))

 ; Ŀ
 ;   Txdd - Text to Date in long year format.                              
 ; 
 (defun C:TXDD ( / tt dd mm yy)
  (setq dd (rtos (fix (getvar "cdate"))))
  (setq yy (substr dd 1 4) mm (substr dd 5 2) da (substr dd 7 2))
  (setq dd (strcat yy "." mm "." da))
  (toaxt dd nil)
 (princ))

(princ)
